   /******************************************
   * Include file                           *
  * by tek                                 *
 * defining macros & objects for a scene. *
******************************************/


 /*************
 * Constants *
*************/

//to fit into 30x40 blocks, suggest do bits for 30x30, then add a 10 long straight bit in the z direction, or 2 5long straight bits.
#declare block_x = 30;
#declare block_z = 40;
#declare road_width = 10;
#declare road_thickness = 0.2;
#declare kerb_width = 0.5;
#declare kerb_height = 0.5;

 /************
 * Textures *
************/

#declare road_surface =
	texture {
		pigment { rgbft <0.1, 0.3, 1.0, 0.3, 0.7>	}
		finish {
			metallic
			ambient 0.8
			diffuse 0.4
			specular 1.0 roughness 0.2
		}
	}

#declare kerb_tex =
	texture {
		pigment { rgb <1.0, 1.0, 1.0>	}
		finish {
			metallic
			ambient 0.6
			diffuse 0.4
			specular 1.0 roughness 0.05
		}
	}


 /***********
 * Objects *
***********/

/*
   _                _
	| |______________| | no rounded corners.
  ''
*/


#declare road_straight_z =
	union {
		intersection {
			plane { x, road_width/2 texture { kerb_tex } }
			plane { -x, -road_width/2 + kerb_width texture { kerb_tex } }
			plane { y, kerb_height texture { kerb_tex } }
			plane { -y, 0 texture { kerb_tex } }
			plane { z, block_z/2 texture { road_surface } }
			plane { -z, block_z/2 texture { road_surface } }
		}
		intersection {
			plane { -x, road_width/2 texture { kerb_tex } }
			plane { x, -road_width/2 + kerb_width texture { kerb_tex } }
			plane { y, kerb_height texture { kerb_tex } }
			plane { -y, 0 texture { kerb_tex } }
			plane { z, block_z/2 texture { road_surface } }
			plane { -z, block_z/2 texture { road_surface } }
		}
		intersection {
			plane { -y, 0 texture { road_surface } }
			plane { y, road_thickness texture { road_surface } }
			plane { x, road_width/2 - kerb_width texture { kerb_tex } }
			plane { -x, road_width/2 - kerb_width texture { kerb_tex } }
			plane { z, block_z/2 texture { road_surface } }
			plane { -z, block_z/2 texture { road_surface } }
		}
	}

#declare road_straight_x =
	intersection {
		plane { x, block_x/2 texture { road_surface } }
		plane { -x, block_x/2 texture { road_surface } }
		plane { z, road_width/2 texture { kerb_tex } }
		plane { -z, road_width/2 texture { kerb_tex } }
		plane { y, kerb_height texture { kerb_tex } }
		plane { -y, 0 texture { road_surface } }
		union {
			plane { y, road_thickness texture { road_surface } }
			plane { z, -road_width/2 + kerb_width texture { kerb_tex } }
			plane { -z, -road_width/2 + kerb_width texture { kerb_tex } }
		}
	}


#declare road_corner =
	union {
		difference {
			intersection {
				plane { -z, block_x/2 texture { road_surface } }
				plane { -x, block_x/2 texture { road_surface } }
				plane { -y, 0 texture { road_surface } }
				cylinder { <-block_x/2, -1, -block_x/2>, <-block_x/2, 1+kerb_height, -block_x/2>, block_x/2 + road_width/2 texture { kerb_tex } }
				union {
					difference {
						plane { y, kerb_height texture { kerb_tex } }
						difference {
							cylinder { <-block_x/2, -1, -block_x/2>, <-block_x/2, 1+kerb_height, -block_x/2>, block_x/2 + road_width/2 - kerb_width texture { kerb_tex } }
							cylinder { <-block_x/2, -1, -block_x/2>, <-block_x/2, 1+kerb_height, -block_x/2>, block_x/2 - road_width/2 + kerb_width texture { kerb_tex } }
						}
					}
					plane { y, road_thickness texture { road_surface } }
				}
			}
			cylinder { <-block_x/2, -1, -block_x/2>, <-block_x/2, 1+kerb_height, -block_x/2>, block_x/2 - road_width/2 texture { kerb_tex } }
		}
		object { road_straight_z translate <0,0,-block_z/2> scale <1,1,(block_z - block_x)/(2*block_z)> translate <0,0,-block_x/2> }
	}


//do junctions as forks, just overlay corner and straight.
#declare road_junction_z =
	union {
		object { road_corner }
		object { road_straight_x }
	}

#declare road_junction_x =
	union {
		object { road_corner }
		object { road_straight_z }
	}


 
 
#ifndef ( sub_image )
	//do a test render
	
	#declare group_rotate = <20,-45,0>;
	
	#declare cam_dist = 2;

	camera {
		right z*4/3
		up -x
		direction -y*cam_dist/4 //hey, if you varied cam_dist with time you'd get the Jaws zoom effect. cool. but cheesy.
		
		location <0.0,1.0,0.0>*cam_dist
		look_at <0,0,0>
		rotate group_rotate
	}


	#declare final_image = true;

	#include "environment.inc"
	
	object { lights }
	
	sky_sphere { skydome }
/*
	#include "ground.inc"
  
	object { ground }
*/
	
	object { road_straight_z scale 0.05 translate <0.9,0,-1.5> rotate group_rotate }
	object { road_straight_x scale 0.05 translate <0,0,0> rotate group_rotate }
	object { road_corner		 scale 0.05 translate <0.9,0,1.5> rotate group_rotate }
	object { road_junction_z scale 0.05 translate <-0.9,0,-1.5> rotate group_rotate }
	object { road_junction_x scale 0.05 translate <-0.9,0,1.5> rotate group_rotate }
	
#end
